
# Table 5 - Peptidoform level analysis #
# Unique protein sites #

#> [conflicted] Will prefer dplyr::filter over any other package
suppressPackageStartupMessages(library("tidyverse"))

library(dplyr)
library(stringr)
library(useful)
library(MASS)
library(reshape2)
library(epiDisplay)
library(gmodels)

PXD000923A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD000923A_pform.csv")
PXD002222A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD002222A_pform.csv")
PXD002756A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD002756A_pform.csv")
PXD004705A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD004705A_pform.csv")
PXD004939A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD004939A_pform.csv")
PXD005241A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD005241A_pform.csv")
PXD012764A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD012764A_pform.csv")
PXD019291A_pform_MQ<- read.csv("D:/Pipeline comparisons/Writing/Data/MQ/Rice/pform/MQ_PXD019291A_pform.csv")

PXD000923A_pform_MQ$PROTEIN_LOC<- paste0(PXD000923A_pform_MQ$Single_Protein,"_",PXD000923A_pform_MQ$PROTEIN_POS_NUM)
PXD002222A_pform_MQ$PROTEIN_LOC<- paste0(PXD002222A_pform_MQ$Single_Protein,"_",PXD002222A_pform_MQ$PROTEIN_POS_NUM)
PXD002756A_pform_MQ$PROTEIN_LOC<- paste0(PXD002756A_pform_MQ$Single_Protein,"_",PXD002756A_pform_MQ$PROTEIN_POS_NUM)
PXD004705A_pform_MQ$PROTEIN_LOC<- paste0(PXD004705A_pform_MQ$Single_Protein,"_",PXD004705A_pform_MQ$PROTEIN_POS_NUM)
PXD004939A_pform_MQ$PROTEIN_LOC<- paste0(PXD004939A_pform_MQ$Single_Protein,"_",PXD004939A_pform_MQ$PROTEIN_POS_NUM)
PXD005241A_pform_MQ$PROTEIN_LOC<- paste0(PXD005241A_pform_MQ$Single_Protein,"_",PXD005241A_pform_MQ$PROTEIN_POS_NUM)
PXD012764A_pform_MQ$PROTEIN_LOC<- paste0(PXD012764A_pform_MQ$Single_Protein,"_",PXD012764A_pform_MQ$PROTEIN_POS_NUM)
PXD019291A_pform_MQ$PROTEIN_LOC<- paste0(PXD019291A_pform_MQ$Single_Protein,"_",PXD019291A_pform_MQ$PROTEIN_POS_NUM)

PXD000923A_pform_MQ$Type <- ifelse(PXD000923A_pform_MQ$Amino == "A","A","STY")
PXD002222A_pform_MQ$Type <- ifelse(PXD002222A_pform_MQ$Amino == "A","A","STY")
PXD002756A_pform_MQ$Type <- ifelse(PXD002756A_pform_MQ$Amino == "A","A","STY")
PXD004705A_pform_MQ$Type <- ifelse(PXD004705A_pform_MQ$Amino == "A","A","STY")
PXD004939A_pform_MQ$Type <- ifelse(PXD004939A_pform_MQ$Amino == "A","A","STY")
PXD005241A_pform_MQ$Type <- ifelse(PXD005241A_pform_MQ$Amino == "A","A","STY")
PXD012764A_pform_MQ$Type <- ifelse(PXD012764A_pform_MQ$Amino == "A","A","STY")
PXD019291A_pform_MQ$Type <- ifelse(PXD019291A_pform_MQ$Amino == "A","A","STY")

PXD000923A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD000923A_pform.csv")
PXD002222A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002222A_pform.csv")
PXD002756A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD002756A_pform.csv")
PXD004705A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004705A_pform.csv")
PXD004939A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD004939A_pform.csv")
PXD005241A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD005241A_pform.csv")
PXD012764A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD012764A_pform.csv")
PXD019291A_pform_PD<- read.csv("D:/Pipeline comparisons/Writing/Data/PD/Rice/pform/PD_PXD019291A_pform.csv")

PXD000923A_pform_PD$Type <- ifelse(PXD000923A_pform_PD$Amino == "A","A","STY")
PXD002222A_pform_PD$Type <- ifelse(PXD002222A_pform_PD$Amino == "A","A","STY")
PXD002756A_pform_PD$Type <- ifelse(PXD002756A_pform_PD$Amino == "A","A","STY")
PXD004705A_pform_PD$Type <- ifelse(PXD004705A_pform_PD$Amino == "A","A","STY")
PXD004939A_pform_PD$Type <- ifelse(PXD004939A_pform_PD$Amino == "A","A","STY")
PXD005241A_pform_PD$Type <- ifelse(PXD005241A_pform_PD$Amino == "A","A","STY")
PXD012764A_pform_PD$Type <- ifelse(PXD012764A_pform_PD$Amino == "A","A","STY")
PXD019291A_pform_PD$Type <- ifelse(PXD019291A_pform_PD$Amino == "A","A","STY")

PXD000923A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD000923A_pform.csv")
PXD002222A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD002222A_pform.csv")
PXD002756A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD002756A_pform.csv")
PXD004705A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD004705A_pform.csv")
PXD004939A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD004939A_pform.csv")
PXD005241A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD005241A_pform.csv")
PXD012764A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD012764A_pform.csv")
PXD019291A_pform_TPP<- read.csv("D:/Pipeline comparisons/Writing/Data/TPP/Rice/pform/TPP_PXD019291A_pform.csv")

PXD000923A_pform_TPP$Type <- ifelse(PXD000923A_pform_TPP$Amino == "A","A","STY")
PXD002222A_pform_TPP$Type <- ifelse(PXD002222A_pform_TPP$Amino == "A","A","STY")
PXD002756A_pform_TPP$Type <- ifelse(PXD002756A_pform_TPP$Amino == "A","A","STY")
PXD004705A_pform_TPP$Type <- ifelse(PXD004705A_pform_TPP$Amino == "A","A","STY")
PXD004939A_pform_TPP$Type <- ifelse(PXD004939A_pform_TPP$Amino == "A","A","STY")
PXD005241A_pform_TPP$Type <- ifelse(PXD005241A_pform_TPP$Amino == "A","A","STY")
PXD012764A_pform_TPP$Type <- ifelse(PXD012764A_pform_TPP$Amino == "A","A","STY")
PXD019291A_pform_TPP$Type <- ifelse(PXD019291A_pform_TPP$Amino == "A","A","STY")

# MQ #
######

PXD000923A_pform_MQ_01 <- PXD000923A_pform_MQ[1:max(which(PXD000923A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD002222A_pform_MQ_01 <- PXD002222A_pform_MQ[1:max(which(PXD002222A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD002756A_pform_MQ_01 <- PXD002756A_pform_MQ[1:max(which(PXD002756A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD004705A_pform_MQ_01 <- PXD004705A_pform_MQ[1:max(which(PXD004705A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD004939A_pform_MQ_01 <- PXD004939A_pform_MQ[1:max(which(PXD004939A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD005241A_pform_MQ_01 <- PXD005241A_pform_MQ[1:max(which(PXD005241A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD012764A_pform_MQ_01 <- PXD012764A_pform_MQ[1:max(which(PXD012764A_pform_MQ$FLR_Adj_Score<=0.01)),]
PXD019291A_pform_MQ_01 <- PXD019291A_pform_MQ[1:max(which(PXD019291A_pform_MQ$FLR_Adj_Score<=0.01)),]

PXD000923A_pform_MQ_02.5 <- PXD000923A_pform_MQ[1:max(which(PXD000923A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD002222A_pform_MQ_02.5 <- PXD002222A_pform_MQ[1:max(which(PXD002222A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD002756A_pform_MQ_02.5 <- PXD002756A_pform_MQ[1:max(which(PXD002756A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD004705A_pform_MQ_02.5 <- PXD004705A_pform_MQ[1:max(which(PXD004705A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD004939A_pform_MQ_02.5 <- PXD004939A_pform_MQ[1:max(which(PXD004939A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD005241A_pform_MQ_02.5 <- PXD005241A_pform_MQ[1:max(which(PXD005241A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD012764A_pform_MQ_02.5 <- PXD012764A_pform_MQ[1:max(which(PXD012764A_pform_MQ$FLR_Adj_Score<=0.025)),]
PXD019291A_pform_MQ_02.5 <- PXD019291A_pform_MQ[1:max(which(PXD019291A_pform_MQ$FLR_Adj_Score<=0.025)),]

PXD000923A_pform_MQ_05 <- PXD000923A_pform_MQ[1:max(which(PXD000923A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD002222A_pform_MQ_05 <- PXD002222A_pform_MQ[1:max(which(PXD002222A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD002756A_pform_MQ_05 <- PXD002756A_pform_MQ[1:max(which(PXD002756A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD004705A_pform_MQ_05 <- PXD004705A_pform_MQ[1:max(which(PXD004705A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD004939A_pform_MQ_05 <- PXD004939A_pform_MQ[1:max(which(PXD004939A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD005241A_pform_MQ_05 <- PXD005241A_pform_MQ[1:max(which(PXD005241A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD012764A_pform_MQ_05 <- PXD012764A_pform_MQ[1:max(which(PXD012764A_pform_MQ$FLR_Adj_Score<=0.05)),]
PXD019291A_pform_MQ_05 <- PXD019291A_pform_MQ[1:max(which(PXD019291A_pform_MQ$FLR_Adj_Score<=0.05)),]

# PD #
######

PXD000923A_pform_PD_01 <- PXD000923A_pform_PD[1:max(which(PXD000923A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD002222A_pform_PD_01 <- PXD002222A_pform_PD[1:max(which(PXD002222A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD002756A_pform_PD_01 <- PXD002756A_pform_PD[1:max(which(PXD002756A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD004705A_pform_PD_01 <- PXD004705A_pform_PD[1:max(which(PXD004705A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD004939A_pform_PD_01 <- PXD004939A_pform_PD[1:max(which(PXD004939A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD005241A_pform_PD_01 <- PXD005241A_pform_PD[1:max(which(PXD005241A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD012764A_pform_PD_01 <- PXD012764A_pform_PD[1:max(which(PXD012764A_pform_PD$FLR_Adj_Score<=0.01)),]
PXD019291A_pform_PD_01 <- PXD019291A_pform_PD[1:max(which(PXD019291A_pform_PD$FLR_Adj_Score<=0.01)),]

PXD000923A_pform_PD_02.5 <- PXD000923A_pform_PD[1:max(which(PXD000923A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD002222A_pform_PD_02.5 <- PXD002222A_pform_PD[1:max(which(PXD002222A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD002756A_pform_PD_02.5 <- PXD002756A_pform_PD[1:max(which(PXD002756A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD004705A_pform_PD_02.5 <- PXD004705A_pform_PD[1:max(which(PXD004705A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD004939A_pform_PD_02.5 <- PXD004939A_pform_PD[1:max(which(PXD004939A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD005241A_pform_PD_02.5 <- PXD005241A_pform_PD[1:max(which(PXD005241A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD012764A_pform_PD_02.5 <- PXD012764A_pform_PD[1:max(which(PXD012764A_pform_PD$FLR_Adj_Score<=0.025)),]
PXD019291A_pform_PD_02.5 <- PXD019291A_pform_PD[1:max(which(PXD019291A_pform_PD$FLR_Adj_Score<=0.025)),]

PXD000923A_pform_PD_05 <- PXD000923A_pform_PD[1:max(which(PXD000923A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD002222A_pform_PD_05 <- PXD002222A_pform_PD[1:max(which(PXD002222A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD002756A_pform_PD_05 <- PXD002756A_pform_PD[1:max(which(PXD002756A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD004705A_pform_PD_05 <- PXD004705A_pform_PD[1:max(which(PXD004705A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD004939A_pform_PD_05 <- PXD004939A_pform_PD[1:max(which(PXD004939A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD005241A_pform_PD_05 <- PXD005241A_pform_PD[1:max(which(PXD005241A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD012764A_pform_PD_05 <- PXD012764A_pform_PD[1:max(which(PXD012764A_pform_PD$FLR_Adj_Score<=0.05)),]
PXD019291A_pform_PD_05 <- PXD019291A_pform_PD[1:max(which(PXD019291A_pform_PD$FLR_Adj_Score<=0.05)),]


# TPP #
######

PXD000923A_pform_TPP_01 <- PXD000923A_pform_TPP[1:max(which(PXD000923A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD002222A_pform_TPP_01 <- PXD002222A_pform_TPP[1:max(which(PXD002222A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD002756A_pform_TPP_01 <- PXD002756A_pform_TPP[1:max(which(PXD002756A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD004705A_pform_TPP_01 <- PXD004705A_pform_TPP[1:max(which(PXD004705A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD004939A_pform_TPP_01 <- PXD004939A_pform_TPP[1:max(which(PXD004939A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD005241A_pform_TPP_01 <- PXD005241A_pform_TPP[1:max(which(PXD005241A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD012764A_pform_TPP_01 <- PXD012764A_pform_TPP[1:max(which(PXD012764A_pform_TPP$FLR_Adj_Score<=0.01)),]
PXD019291A_pform_TPP_01 <- PXD019291A_pform_TPP[1:max(which(PXD019291A_pform_TPP$FLR_Adj_Score<=0.01)),]

PXD000923A_pform_TPP_02.5 <- PXD000923A_pform_TPP[1:max(which(PXD000923A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD002222A_pform_TPP_02.5 <- PXD002222A_pform_TPP[1:max(which(PXD002222A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD002756A_pform_TPP_02.5 <- PXD002756A_pform_TPP[1:max(which(PXD002756A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD004705A_pform_TPP_02.5 <- PXD004705A_pform_TPP[1:max(which(PXD004705A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD004939A_pform_TPP_02.5 <- PXD004939A_pform_TPP[1:max(which(PXD004939A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD005241A_pform_TPP_02.5 <- PXD005241A_pform_TPP[1:max(which(PXD005241A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD012764A_pform_TPP_02.5 <- PXD012764A_pform_TPP[1:max(which(PXD012764A_pform_TPP$FLR_Adj_Score<=0.025)),]
PXD019291A_pform_TPP_02.5 <- PXD019291A_pform_TPP[1:max(which(PXD019291A_pform_TPP$FLR_Adj_Score<=0.025)),]

PXD000923A_pform_TPP_05 <- PXD000923A_pform_TPP[1:max(which(PXD000923A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD002222A_pform_TPP_05 <- PXD002222A_pform_TPP[1:max(which(PXD002222A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD002756A_pform_TPP_05 <- PXD002756A_pform_TPP[1:max(which(PXD002756A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD004705A_pform_TPP_05 <- PXD004705A_pform_TPP[1:max(which(PXD004705A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD004939A_pform_TPP_05 <- PXD004939A_pform_TPP[1:max(which(PXD004939A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD005241A_pform_TPP_05 <- PXD005241A_pform_TPP[1:max(which(PXD005241A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD012764A_pform_TPP_05 <- PXD012764A_pform_TPP[1:max(which(PXD012764A_pform_TPP$FLR_Adj_Score<=0.05)),]
PXD019291A_pform_TPP_05 <- PXD019291A_pform_TPP[1:max(which(PXD019291A_pform_TPP$FLR_Adj_Score<=0.05)),]


# All Unique sites


Unique_PXD000923A_pform_TPP <- cbind.data.frame(distinct(PXD000923A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002222A_pform_TPP <- cbind.data.frame(distinct(PXD002222A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002756A_pform_TPP <- cbind.data.frame(distinct(PXD002756A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004705A_pform_TPP <- cbind.data.frame(distinct(PXD004705A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004939A_pform_TPP <- cbind.data.frame(distinct(PXD004939A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD005241A_pform_TPP <- cbind.data.frame(distinct(PXD005241A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD012764A_pform_TPP <- cbind.data.frame(distinct(PXD012764A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD019291A_pform_TPP <- cbind.data.frame(distinct(PXD019291A_pform_TPP,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")

Unique_PXD000923A_pform_TPP <- dplyr::select(Unique_PXD000923A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_TPP <- dplyr::select(Unique_PXD002222A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_TPP <- dplyr::select(Unique_PXD002756A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_TPP <- dplyr::select(Unique_PXD004705A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_TPP <- dplyr::select(Unique_PXD004939A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_TPP <- dplyr::select(Unique_PXD005241A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_TPP <- dplyr::select(Unique_PXD012764A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_TPP <- dplyr::select(Unique_PXD019291A_pform_TPP,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_PD <- cbind.data.frame(distinct(PXD000923A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002222A_pform_PD <- cbind.data.frame(distinct(PXD002222A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002756A_pform_PD <- cbind.data.frame(distinct(PXD002756A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004705A_pform_PD <- cbind.data.frame(distinct(PXD004705A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004939A_pform_PD <- cbind.data.frame(distinct(PXD004939A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD005241A_pform_PD <- cbind.data.frame(distinct(PXD005241A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD012764A_pform_PD <- cbind.data.frame(distinct(PXD012764A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD019291A_pform_PD <- cbind.data.frame(distinct(PXD019291A_pform_PD,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")

Unique_PXD000923A_pform_PD <- dplyr::select(Unique_PXD000923A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_PD <- dplyr::select(Unique_PXD002222A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_PD <- dplyr::select(Unique_PXD002756A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_PD <- dplyr::select(Unique_PXD004705A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_PD <- dplyr::select(Unique_PXD004939A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_PD <- dplyr::select(Unique_PXD005241A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_PD <- dplyr::select(Unique_PXD012764A_pform_PD,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_PD <- dplyr::select(Unique_PXD019291A_pform_PD,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_MQ <- cbind.data.frame(distinct(PXD000923A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002222A_pform_MQ <- cbind.data.frame(distinct(PXD002222A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002756A_pform_MQ <- cbind.data.frame(distinct(PXD002756A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004705A_pform_MQ <- cbind.data.frame(distinct(PXD004705A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004939A_pform_MQ <- cbind.data.frame(distinct(PXD004939A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD005241A_pform_MQ <- cbind.data.frame(distinct(PXD005241A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD012764A_pform_MQ <- cbind.data.frame(distinct(PXD012764A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD019291A_pform_MQ <- cbind.data.frame(distinct(PXD019291A_pform_MQ,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")

Unique_PXD000923A_pform_MQ <- dplyr::select(Unique_PXD000923A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_MQ <- dplyr::select(Unique_PXD002222A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_MQ <- dplyr::select(Unique_PXD002756A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_MQ <- dplyr::select(Unique_PXD004705A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_MQ <- dplyr::select(Unique_PXD004939A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_MQ <- dplyr::select(Unique_PXD005241A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_MQ <- dplyr::select(Unique_PXD012764A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_MQ <- dplyr::select(Unique_PXD019291A_pform_MQ,c(PROTEIN_LOC,pipeline,Type))

# Merging data #
################

M1_PXD000923A <- merge(Unique_PXD000923A_pform_TPP,Unique_PXD000923A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD000923A <- merge(M1_PXD000923A,Unique_PXD000923A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD002222A <- merge(Unique_PXD002222A_pform_TPP,Unique_PXD002222A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002222A <- merge(M1_PXD002222A,Unique_PXD002222A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD002756A <- merge(Unique_PXD002756A_pform_TPP,Unique_PXD002756A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002756A <- merge(M1_PXD002756A,Unique_PXD002756A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD004705A <- merge(Unique_PXD004705A_pform_TPP,Unique_PXD004705A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004705A <- merge(M1_PXD004705A,Unique_PXD004705A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD004939A <- merge(Unique_PXD004939A_pform_TPP,Unique_PXD004939A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004939A <- merge(M1_PXD004939A,Unique_PXD004939A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD005241A <- merge(Unique_PXD005241A_pform_TPP,Unique_PXD005241A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD005241A <- merge(M1_PXD005241A,Unique_PXD005241A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD012764A <- merge(Unique_PXD012764A_pform_TPP,Unique_PXD012764A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD012764A <- merge(M1_PXD012764A,Unique_PXD012764A_pform_MQ, by="PROTEIN_LOC", all = TRUE)
M1_PXD019291A <- merge(Unique_PXD019291A_pform_TPP,Unique_PXD019291A_pform_PD, by="PROTEIN_LOC", all = TRUE)
Merged_PXD019291A <- merge(M1_PXD019291A,Unique_PXD019291A_pform_MQ, by="PROTEIN_LOC", all = TRUE)

Merged_PXD000923A$Group <- paste0(Merged_PXD000923A$pipeline.x,"_",Merged_PXD000923A$pipeline.y,"_",Merged_PXD000923A$pipeline)
Merged_PXD000923A$Group <- gsub('_NA', '', Merged_PXD000923A$Group)
Merged_PXD000923A$Group <- gsub('NA_', '', Merged_PXD000923A$Group)
Merged_PXD000923A$Type <- coalesce(Merged_PXD000923A$Type,Merged_PXD000923A$Type.x,Merged_PXD000923A$Type.y)

Merged_PXD002222A$Group <- paste0(Merged_PXD002222A$pipeline.x,"_",Merged_PXD002222A$pipeline.y,"_",Merged_PXD002222A$pipeline)
Merged_PXD002222A$Group <- gsub('_NA', '', Merged_PXD002222A$Group)
Merged_PXD002222A$Group <- gsub('NA_', '', Merged_PXD002222A$Group)
Merged_PXD002222A$Type <- coalesce(Merged_PXD002222A$Type,Merged_PXD002222A$Type.x,Merged_PXD002222A$Type.y)

Merged_PXD002756A$Group <- paste0(Merged_PXD002756A$pipeline.x,"_",Merged_PXD002756A$pipeline.y,"_",Merged_PXD002756A$pipeline)
Merged_PXD002756A$Group <- gsub('_NA', '', Merged_PXD002756A$Group)
Merged_PXD002756A$Group <- gsub('NA_', '', Merged_PXD002756A$Group)
Merged_PXD002756A$Type <- coalesce(Merged_PXD002756A$Type,Merged_PXD002756A$Type.x,Merged_PXD002756A$Type.y)

Merged_PXD004705A$Group <- paste0(Merged_PXD004705A$pipeline.x,"_",Merged_PXD004705A$pipeline.y,"_",Merged_PXD004705A$pipeline)
Merged_PXD004705A$Group <- gsub('_NA', '', Merged_PXD004705A$Group)
Merged_PXD004705A$Group <- gsub('NA_', '', Merged_PXD004705A$Group)
Merged_PXD004705A$Type <- coalesce(Merged_PXD004705A$Type,Merged_PXD004705A$Type.x,Merged_PXD004705A$Type.y)

Merged_PXD004939A$Group <- paste0(Merged_PXD004939A$pipeline.x,"_",Merged_PXD004939A$pipeline.y,"_",Merged_PXD004939A$pipeline)
Merged_PXD004939A$Group <- gsub('_NA', '', Merged_PXD004939A$Group)
Merged_PXD004939A$Group <- gsub('NA_', '', Merged_PXD004939A$Group)
Merged_PXD004939A$Type <- coalesce(Merged_PXD004939A$Type,Merged_PXD004939A$Type.x,Merged_PXD004939A$Type.y)

Merged_PXD005241A$Group <- paste0(Merged_PXD005241A$pipeline.x,"_",Merged_PXD005241A$pipeline.y,"_",Merged_PXD005241A$pipeline)
Merged_PXD005241A$Group <- gsub('_NA', '', Merged_PXD005241A$Group)
Merged_PXD005241A$Group <- gsub('NA_', '', Merged_PXD005241A$Group)
Merged_PXD005241A$Type <- coalesce(Merged_PXD005241A$Type,Merged_PXD005241A$Type.x,Merged_PXD005241A$Type.y)

Merged_PXD012764A$Group <- paste0(Merged_PXD012764A$pipeline.x,"_",Merged_PXD012764A$pipeline.y,"_",Merged_PXD012764A$pipeline)
Merged_PXD012764A$Group <- gsub('_NA', '', Merged_PXD012764A$Group)
Merged_PXD012764A$Group <- gsub('NA_', '', Merged_PXD012764A$Group)
Merged_PXD012764A$Type <- coalesce(Merged_PXD012764A$Type,Merged_PXD012764A$Type.x,Merged_PXD012764A$Type.y)

Merged_PXD019291A$Group <- paste0(Merged_PXD019291A$pipeline.x,"_",Merged_PXD019291A$pipeline.y,"_",Merged_PXD019291A$pipeline)
Merged_PXD019291A$Group <- gsub('_NA', '', Merged_PXD019291A$Group)
Merged_PXD019291A$Group <- gsub('NA_', '', Merged_PXD019291A$Group)
Merged_PXD019291A$Type <- coalesce(Merged_PXD019291A$Type,Merged_PXD019291A$Type.x,Merged_PXD019291A$Type.y)

CrossTable(Merged_PXD000923A$Group,Merged_PXD000923A$Type)
CrossTable(Merged_PXD002222A$Group,Merged_PXD002222A$Type)
CrossTable(Merged_PXD002756A$Group,Merged_PXD002756A$Type)
CrossTable(Merged_PXD004705A$Group,Merged_PXD004705A$Type)
CrossTable(Merged_PXD004939A$Group,Merged_PXD004939A$Type)
CrossTable(Merged_PXD005241A$Group,Merged_PXD005241A$Type)
CrossTable(Merged_PXD012764A$Group,Merged_PXD012764A$Type)
CrossTable(Merged_PXD019291A$Group,Merged_PXD019291A$Type)

# 5% FLR #
##########


Unique_PXD000923A_pform_TPP_05 <- cbind.data.frame(distinct(PXD000923A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002222A_pform_TPP_05 <- cbind.data.frame(distinct(PXD002222A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002756A_pform_TPP_05 <- cbind.data.frame(distinct(PXD002756A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004705A_pform_TPP_05 <- cbind.data.frame(distinct(PXD004705A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004939A_pform_TPP_05 <- cbind.data.frame(distinct(PXD004939A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD005241A_pform_TPP_05 <- cbind.data.frame(distinct(PXD005241A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD012764A_pform_TPP_05 <- cbind.data.frame(distinct(PXD012764A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD019291A_pform_TPP_05 <- cbind.data.frame(distinct(PXD019291A_pform_TPP_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")

Unique_PXD000923A_pform_TPP_05 <- dplyr::select(Unique_PXD000923A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_TPP_05 <- dplyr::select(Unique_PXD002222A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_TPP_05 <- dplyr::select(Unique_PXD002756A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_TPP_05 <- dplyr::select(Unique_PXD004705A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_TPP_05 <- dplyr::select(Unique_PXD004939A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_TPP_05 <- dplyr::select(Unique_PXD005241A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_TPP_05 <- dplyr::select(Unique_PXD012764A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_TPP_05 <- dplyr::select(Unique_PXD019291A_pform_TPP_05,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_PD_05 <- cbind.data.frame(distinct(PXD000923A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002222A_pform_PD_05 <- cbind.data.frame(distinct(PXD002222A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002756A_pform_PD_05 <- cbind.data.frame(distinct(PXD002756A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004705A_pform_PD_05 <- cbind.data.frame(distinct(PXD004705A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004939A_pform_PD_05 <- cbind.data.frame(distinct(PXD004939A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD005241A_pform_PD_05 <- cbind.data.frame(distinct(PXD005241A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD012764A_pform_PD_05 <- cbind.data.frame(distinct(PXD012764A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD019291A_pform_PD_05 <- cbind.data.frame(distinct(PXD019291A_pform_PD_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")

Unique_PXD000923A_pform_PD_05 <- dplyr::select(Unique_PXD000923A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_PD_05 <- dplyr::select(Unique_PXD002222A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_PD_05 <- dplyr::select(Unique_PXD002756A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_PD_05 <- dplyr::select(Unique_PXD004705A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_PD_05 <- dplyr::select(Unique_PXD004939A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_PD_05 <- dplyr::select(Unique_PXD005241A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_PD_05 <- dplyr::select(Unique_PXD012764A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_PD_05 <- dplyr::select(Unique_PXD019291A_pform_PD_05,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_MQ_05 <- cbind.data.frame(distinct(PXD000923A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002222A_pform_MQ_05 <- cbind.data.frame(distinct(PXD002222A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002756A_pform_MQ_05 <- cbind.data.frame(distinct(PXD002756A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004705A_pform_MQ_05 <- cbind.data.frame(distinct(PXD004705A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004939A_pform_MQ_05 <- cbind.data.frame(distinct(PXD004939A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD005241A_pform_MQ_05 <- cbind.data.frame(distinct(PXD005241A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD012764A_pform_MQ_05 <- cbind.data.frame(distinct(PXD012764A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD019291A_pform_MQ_05 <- cbind.data.frame(distinct(PXD019291A_pform_MQ_05,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")

Unique_PXD000923A_pform_MQ_05 <- dplyr::select(Unique_PXD000923A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_MQ_05 <- dplyr::select(Unique_PXD002222A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_MQ_05 <- dplyr::select(Unique_PXD002756A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_MQ_05 <- dplyr::select(Unique_PXD004705A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_MQ_05 <- dplyr::select(Unique_PXD004939A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_MQ_05 <- dplyr::select(Unique_PXD005241A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_MQ_05 <- dplyr::select(Unique_PXD012764A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_MQ_05 <- dplyr::select(Unique_PXD019291A_pform_MQ_05,c(PROTEIN_LOC,pipeline,Type))

# Merging data #
################

M1_PXD000923A_05 <- merge(Unique_PXD000923A_pform_TPP_05,Unique_PXD000923A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD000923A_05 <- merge(M1_PXD000923A_05,Unique_PXD000923A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD002222A_05 <- merge(Unique_PXD002222A_pform_TPP_05,Unique_PXD002222A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002222A_05 <- merge(M1_PXD002222A_05,Unique_PXD002222A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD002756A_05 <- merge(Unique_PXD002756A_pform_TPP_05,Unique_PXD002756A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002756A_05 <- merge(M1_PXD002756A_05,Unique_PXD002756A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD004705A_05 <- merge(Unique_PXD004705A_pform_TPP_05,Unique_PXD004705A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004705A_05 <- merge(M1_PXD004705A_05,Unique_PXD004705A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD004939A_05 <- merge(Unique_PXD004939A_pform_TPP_05,Unique_PXD004939A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004939A_05 <- merge(M1_PXD004939A_05,Unique_PXD004939A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD005241A_05 <- merge(Unique_PXD005241A_pform_TPP_05,Unique_PXD005241A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD005241A_05 <- merge(M1_PXD005241A_05,Unique_PXD005241A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD012764A_05 <- merge(Unique_PXD012764A_pform_TPP_05,Unique_PXD012764A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD012764A_05 <- merge(M1_PXD012764A_05,Unique_PXD012764A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)
M1_PXD019291A_05 <- merge(Unique_PXD019291A_pform_TPP_05,Unique_PXD019291A_pform_PD_05, by="PROTEIN_LOC", all = TRUE)
Merged_PXD019291A_05 <- merge(M1_PXD019291A_05,Unique_PXD019291A_pform_MQ_05, by="PROTEIN_LOC", all = TRUE)

Merged_PXD000923A_05$Group <- paste0(Merged_PXD000923A_05$pipeline.x,"_",Merged_PXD000923A_05$pipeline.y,"_",Merged_PXD000923A_05$pipeline)
Merged_PXD000923A_05$Group <- gsub('_NA', '', Merged_PXD000923A_05$Group)
Merged_PXD000923A_05$Group <- gsub('NA_', '', Merged_PXD000923A_05$Group)
Merged_PXD000923A_05$Type <- coalesce(Merged_PXD000923A_05$Type,Merged_PXD000923A_05$Type.x,Merged_PXD000923A_05$Type.y)

Merged_PXD002222A_05$Group <- paste0(Merged_PXD002222A_05$pipeline.x,"_",Merged_PXD002222A_05$pipeline.y,"_",Merged_PXD002222A_05$pipeline)
Merged_PXD002222A_05$Group <- gsub('_NA', '', Merged_PXD002222A_05$Group)
Merged_PXD002222A_05$Group <- gsub('NA_', '', Merged_PXD002222A_05$Group)
Merged_PXD002222A_05$Type <- coalesce(Merged_PXD002222A_05$Type,Merged_PXD002222A_05$Type.x,Merged_PXD002222A_05$Type.y)

Merged_PXD002756A_05$Group <- paste0(Merged_PXD002756A_05$pipeline.x,"_",Merged_PXD002756A_05$pipeline.y,"_",Merged_PXD002756A_05$pipeline)
Merged_PXD002756A_05$Group <- gsub('_NA', '', Merged_PXD002756A_05$Group)
Merged_PXD002756A_05$Group <- gsub('NA_', '', Merged_PXD002756A_05$Group)
Merged_PXD002756A_05$Type <- coalesce(Merged_PXD002756A_05$Type,Merged_PXD002756A_05$Type.x,Merged_PXD002756A_05$Type.y)

Merged_PXD004705A_05$Group <- paste0(Merged_PXD004705A_05$pipeline.x,"_",Merged_PXD004705A_05$pipeline.y,"_",Merged_PXD004705A_05$pipeline)
Merged_PXD004705A_05$Group <- gsub('_NA', '', Merged_PXD004705A_05$Group)
Merged_PXD004705A_05$Group <- gsub('NA_', '', Merged_PXD004705A_05$Group)
Merged_PXD004705A_05$Type <- coalesce(Merged_PXD004705A_05$Type,Merged_PXD004705A_05$Type.x,Merged_PXD004705A_05$Type.y)

Merged_PXD004939A_05$Group <- paste0(Merged_PXD004939A_05$pipeline.x,"_",Merged_PXD004939A_05$pipeline.y,"_",Merged_PXD004939A_05$pipeline)
Merged_PXD004939A_05$Group <- gsub('_NA', '', Merged_PXD004939A_05$Group)
Merged_PXD004939A_05$Group <- gsub('NA_', '', Merged_PXD004939A_05$Group)
Merged_PXD004939A_05$Type <- coalesce(Merged_PXD004939A_05$Type,Merged_PXD004939A_05$Type.x,Merged_PXD004939A_05$Type.y)

Merged_PXD005241A_05$Group <- paste0(Merged_PXD005241A_05$pipeline.x,"_",Merged_PXD005241A_05$pipeline.y,"_",Merged_PXD005241A_05$pipeline)
Merged_PXD005241A_05$Group <- gsub('_NA', '', Merged_PXD005241A_05$Group)
Merged_PXD005241A_05$Group <- gsub('NA_', '', Merged_PXD005241A_05$Group)
Merged_PXD005241A_05$Type <- coalesce(Merged_PXD005241A_05$Type,Merged_PXD005241A_05$Type.x,Merged_PXD005241A_05$Type.y)

Merged_PXD012764A_05$Group <- paste0(Merged_PXD012764A_05$pipeline.x,"_",Merged_PXD012764A_05$pipeline.y,"_",Merged_PXD012764A_05$pipeline)
Merged_PXD012764A_05$Group <- gsub('_NA', '', Merged_PXD012764A_05$Group)
Merged_PXD012764A_05$Group <- gsub('NA_', '', Merged_PXD012764A_05$Group)
Merged_PXD012764A_05$Type <- coalesce(Merged_PXD012764A_05$Type,Merged_PXD012764A_05$Type.x,Merged_PXD012764A_05$Type.y)

Merged_PXD019291A_05$Group <- paste0(Merged_PXD019291A_05$pipeline.x,"_",Merged_PXD019291A_05$pipeline.y,"_",Merged_PXD019291A_05$pipeline)
Merged_PXD019291A_05$Group <- gsub('_NA', '', Merged_PXD019291A_05$Group)
Merged_PXD019291A_05$Group <- gsub('NA_', '', Merged_PXD019291A_05$Group)
Merged_PXD019291A_05$Type <- coalesce(Merged_PXD019291A_05$Type,Merged_PXD019291A_05$Type.x,Merged_PXD019291A_05$Type.y)

CrossTable(Merged_PXD000923A_05$Group,Merged_PXD000923A_05$Type)
CrossTable(Merged_PXD002222A_05$Group,Merged_PXD002222A_05$Type)
CrossTable(Merged_PXD002756A_05$Group,Merged_PXD002756A_05$Type)
CrossTable(Merged_PXD004705A_05$Group,Merged_PXD004705A_05$Type)
CrossTable(Merged_PXD004939A_05$Group,Merged_PXD004939A_05$Type)
CrossTable(Merged_PXD005241A_05$Group,Merged_PXD005241A_05$Type)
CrossTable(Merged_PXD012764A_05$Group,Merged_PXD012764A_05$Type)
CrossTable(Merged_PXD019291A_05$Group,Merged_PXD019291A_05$Type)

# 2.5% FLR #
##########


Unique_PXD000923A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD000923A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002222A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD002222A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002756A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD002756A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004705A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD004705A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004939A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD004939A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD005241A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD005241A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD012764A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD012764A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD019291A_pform_TPP_2.5 <- cbind.data.frame(distinct(PXD019291A_pform_TPP_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")

Unique_PXD000923A_pform_TPP_2.5 <- dplyr::select(Unique_PXD000923A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_TPP_2.5 <- dplyr::select(Unique_PXD002222A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_TPP_2.5 <- dplyr::select(Unique_PXD002756A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_TPP_2.5 <- dplyr::select(Unique_PXD004705A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_TPP_2.5 <- dplyr::select(Unique_PXD004939A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_TPP_2.5 <- dplyr::select(Unique_PXD005241A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_TPP_2.5 <- dplyr::select(Unique_PXD012764A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_TPP_2.5 <- dplyr::select(Unique_PXD019291A_pform_TPP_2.5,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD000923A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002222A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD002222A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002756A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD002756A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004705A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD004705A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004939A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD004939A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD005241A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD005241A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD012764A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD012764A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD019291A_pform_PD_2.5 <- cbind.data.frame(distinct(PXD019291A_pform_PD_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")

Unique_PXD000923A_pform_PD_2.5 <- dplyr::select(Unique_PXD000923A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_PD_2.5 <- dplyr::select(Unique_PXD002222A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_PD_2.5 <- dplyr::select(Unique_PXD002756A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_PD_2.5 <- dplyr::select(Unique_PXD004705A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_PD_2.5 <- dplyr::select(Unique_PXD004939A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_PD_2.5 <- dplyr::select(Unique_PXD005241A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_PD_2.5 <- dplyr::select(Unique_PXD012764A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_PD_2.5 <- dplyr::select(Unique_PXD019291A_pform_PD_2.5,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD000923A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002222A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD002222A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002756A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD002756A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004705A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD004705A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004939A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD004939A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD005241A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD005241A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD012764A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD012764A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD019291A_pform_MQ_2.5 <- cbind.data.frame(distinct(PXD019291A_pform_MQ_02.5,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")

Unique_PXD000923A_pform_MQ_2.5 <- dplyr::select(Unique_PXD000923A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_MQ_2.5 <- dplyr::select(Unique_PXD002222A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_MQ_2.5 <- dplyr::select(Unique_PXD002756A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_MQ_2.5 <- dplyr::select(Unique_PXD004705A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_MQ_2.5 <- dplyr::select(Unique_PXD004939A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_MQ_2.5 <- dplyr::select(Unique_PXD005241A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_MQ_2.5 <- dplyr::select(Unique_PXD012764A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_MQ_2.5 <- dplyr::select(Unique_PXD019291A_pform_MQ_2.5,c(PROTEIN_LOC,pipeline,Type))

# Merging data #
################

M1_PXD000923A_2.5 <- merge(Unique_PXD000923A_pform_TPP_2.5,Unique_PXD000923A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD000923A_2.5 <- merge(M1_PXD000923A_2.5,Unique_PXD000923A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD002222A_2.5 <- merge(Unique_PXD002222A_pform_TPP_2.5,Unique_PXD002222A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002222A_2.5 <- merge(M1_PXD002222A_2.5,Unique_PXD002222A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD002756A_2.5 <- merge(Unique_PXD002756A_pform_TPP_2.5,Unique_PXD002756A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002756A_2.5 <- merge(M1_PXD002756A_2.5,Unique_PXD002756A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD004705A_2.5 <- merge(Unique_PXD004705A_pform_TPP_2.5,Unique_PXD004705A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004705A_2.5 <- merge(M1_PXD004705A_2.5,Unique_PXD004705A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD004939A_2.5 <- merge(Unique_PXD004939A_pform_TPP_2.5,Unique_PXD004939A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004939A_2.5 <- merge(M1_PXD004939A_2.5,Unique_PXD004939A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD005241A_2.5 <- merge(Unique_PXD005241A_pform_TPP_2.5,Unique_PXD005241A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD005241A_2.5 <- merge(M1_PXD005241A_2.5,Unique_PXD005241A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD012764A_2.5 <- merge(Unique_PXD012764A_pform_TPP_2.5,Unique_PXD012764A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD012764A_2.5 <- merge(M1_PXD012764A_2.5,Unique_PXD012764A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)
M1_PXD019291A_2.5 <- merge(Unique_PXD019291A_pform_TPP_2.5,Unique_PXD019291A_pform_PD_2.5, by="PROTEIN_LOC", all = TRUE)
Merged_PXD019291A_2.5 <- merge(M1_PXD019291A_2.5,Unique_PXD019291A_pform_MQ_2.5, by="PROTEIN_LOC", all = TRUE)

Merged_PXD000923A_2.5$Group <- paste0(Merged_PXD000923A_2.5$pipeline.x,"_",Merged_PXD000923A_2.5$pipeline.y,"_",Merged_PXD000923A_2.5$pipeline)
Merged_PXD000923A_2.5$Group <- gsub('_NA', '', Merged_PXD000923A_2.5$Group)
Merged_PXD000923A_2.5$Group <- gsub('NA_', '', Merged_PXD000923A_2.5$Group)
Merged_PXD000923A_2.5$Type <- coalesce(Merged_PXD000923A_2.5$Type,Merged_PXD000923A_2.5$Type.x,Merged_PXD000923A_2.5$Type.y)

Merged_PXD002222A_2.5$Group <- paste0(Merged_PXD002222A_2.5$pipeline.x,"_",Merged_PXD002222A_2.5$pipeline.y,"_",Merged_PXD002222A_2.5$pipeline)
Merged_PXD002222A_2.5$Group <- gsub('_NA', '', Merged_PXD002222A_2.5$Group)
Merged_PXD002222A_2.5$Group <- gsub('NA_', '', Merged_PXD002222A_2.5$Group)
Merged_PXD002222A_2.5$Type <- coalesce(Merged_PXD002222A_2.5$Type,Merged_PXD002222A_2.5$Type.x,Merged_PXD002222A_2.5$Type.y)

Merged_PXD002756A_2.5$Group <- paste0(Merged_PXD002756A_2.5$pipeline.x,"_",Merged_PXD002756A_2.5$pipeline.y,"_",Merged_PXD002756A_2.5$pipeline)
Merged_PXD002756A_2.5$Group <- gsub('_NA', '', Merged_PXD002756A_2.5$Group)
Merged_PXD002756A_2.5$Group <- gsub('NA_', '', Merged_PXD002756A_2.5$Group)
Merged_PXD002756A_2.5$Type <- coalesce(Merged_PXD002756A_2.5$Type,Merged_PXD002756A_2.5$Type.x,Merged_PXD002756A_2.5$Type.y)

Merged_PXD004705A_2.5$Group <- paste0(Merged_PXD004705A_2.5$pipeline.x,"_",Merged_PXD004705A_2.5$pipeline.y,"_",Merged_PXD004705A_2.5$pipeline)
Merged_PXD004705A_2.5$Group <- gsub('_NA', '', Merged_PXD004705A_2.5$Group)
Merged_PXD004705A_2.5$Group <- gsub('NA_', '', Merged_PXD004705A_2.5$Group)
Merged_PXD004705A_2.5$Type <- coalesce(Merged_PXD004705A_2.5$Type,Merged_PXD004705A_2.5$Type.x,Merged_PXD004705A_2.5$Type.y)

Merged_PXD004939A_2.5$Group <- paste0(Merged_PXD004939A_2.5$pipeline.x,"_",Merged_PXD004939A_2.5$pipeline.y,"_",Merged_PXD004939A_2.5$pipeline)
Merged_PXD004939A_2.5$Group <- gsub('_NA', '', Merged_PXD004939A_2.5$Group)
Merged_PXD004939A_2.5$Group <- gsub('NA_', '', Merged_PXD004939A_2.5$Group)
Merged_PXD004939A_2.5$Type <- coalesce(Merged_PXD004939A_2.5$Type,Merged_PXD004939A_2.5$Type.x,Merged_PXD004939A_2.5$Type.y)

Merged_PXD005241A_2.5$Group <- paste0(Merged_PXD005241A_2.5$pipeline.x,"_",Merged_PXD005241A_2.5$pipeline.y,"_",Merged_PXD005241A_2.5$pipeline)
Merged_PXD005241A_2.5$Group <- gsub('_NA', '', Merged_PXD005241A_2.5$Group)
Merged_PXD005241A_2.5$Group <- gsub('NA_', '', Merged_PXD005241A_2.5$Group)
Merged_PXD005241A_2.5$Type <- coalesce(Merged_PXD005241A_2.5$Type,Merged_PXD005241A_2.5$Type.x,Merged_PXD005241A_2.5$Type.y)

Merged_PXD012764A_2.5$Group <- paste0(Merged_PXD012764A_2.5$pipeline.x,"_",Merged_PXD012764A_2.5$pipeline.y,"_",Merged_PXD012764A_2.5$pipeline)
Merged_PXD012764A_2.5$Group <- gsub('_NA', '', Merged_PXD012764A_2.5$Group)
Merged_PXD012764A_2.5$Group <- gsub('NA_', '', Merged_PXD012764A_2.5$Group)
Merged_PXD012764A_2.5$Type <- coalesce(Merged_PXD012764A_2.5$Type,Merged_PXD012764A_2.5$Type.x,Merged_PXD012764A_2.5$Type.y)

Merged_PXD019291A_2.5$Group <- paste0(Merged_PXD019291A_2.5$pipeline.x,"_",Merged_PXD019291A_2.5$pipeline.y,"_",Merged_PXD019291A_2.5$pipeline)
Merged_PXD019291A_2.5$Group <- gsub('_NA', '', Merged_PXD019291A_2.5$Group)
Merged_PXD019291A_2.5$Group <- gsub('NA_', '', Merged_PXD019291A_2.5$Group)
Merged_PXD019291A_2.5$Type <- coalesce(Merged_PXD019291A_2.5$Type,Merged_PXD019291A_2.5$Type.x,Merged_PXD019291A_2.5$Type.y)

CrossTable(Merged_PXD000923A_2.5$Group,Merged_PXD000923A_2.5$Type)
CrossTable(Merged_PXD002222A_2.5$Group,Merged_PXD002222A_2.5$Type)
CrossTable(Merged_PXD002756A_2.5$Group,Merged_PXD002756A_2.5$Type)
CrossTable(Merged_PXD004705A_2.5$Group,Merged_PXD004705A_2.5$Type)
CrossTable(Merged_PXD004939A_2.5$Group,Merged_PXD004939A_2.5$Type)
CrossTable(Merged_PXD005241A_2.5$Group,Merged_PXD005241A_2.5$Type)
CrossTable(Merged_PXD012764A_2.5$Group,Merged_PXD012764A_2.5$Type)
CrossTable(Merged_PXD019291A_2.5$Group,Merged_PXD019291A_2.5$Type)


# 1% FLR #
##########


Unique_PXD000923A_pform_TPP_01 <- cbind.data.frame(distinct(PXD000923A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002222A_pform_TPP_01 <- cbind.data.frame(distinct(PXD002222A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD002756A_pform_TPP_01 <- cbind.data.frame(distinct(PXD002756A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004705A_pform_TPP_01 <- cbind.data.frame(distinct(PXD004705A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD004939A_pform_TPP_01 <- cbind.data.frame(distinct(PXD004939A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD005241A_pform_TPP_01 <- cbind.data.frame(distinct(PXD005241A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD012764A_pform_TPP_01 <- cbind.data.frame(distinct(PXD012764A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")
Unique_PXD019291A_pform_TPP_01 <- cbind.data.frame(distinct(PXD019291A_pform_TPP_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="TPP")

Unique_PXD000923A_pform_TPP_01 <- dplyr::select(Unique_PXD000923A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_TPP_01 <- dplyr::select(Unique_PXD002222A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_TPP_01 <- dplyr::select(Unique_PXD002756A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_TPP_01 <- dplyr::select(Unique_PXD004705A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_TPP_01 <- dplyr::select(Unique_PXD004939A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_TPP_01 <- dplyr::select(Unique_PXD005241A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_TPP_01 <- dplyr::select(Unique_PXD012764A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_TPP_01 <- dplyr::select(Unique_PXD019291A_pform_TPP_01,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_PD_01 <- cbind.data.frame(distinct(PXD000923A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002222A_pform_PD_01 <- cbind.data.frame(distinct(PXD002222A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD002756A_pform_PD_01 <- cbind.data.frame(distinct(PXD002756A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004705A_pform_PD_01 <- cbind.data.frame(distinct(PXD004705A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD004939A_pform_PD_01 <- cbind.data.frame(distinct(PXD004939A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD005241A_pform_PD_01 <- cbind.data.frame(distinct(PXD005241A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD012764A_pform_PD_01 <- cbind.data.frame(distinct(PXD012764A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")
Unique_PXD019291A_pform_PD_01 <- cbind.data.frame(distinct(PXD019291A_pform_PD_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="PD")

Unique_PXD000923A_pform_PD_01 <- dplyr::select(Unique_PXD000923A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_PD_01 <- dplyr::select(Unique_PXD002222A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_PD_01 <- dplyr::select(Unique_PXD002756A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_PD_01 <- dplyr::select(Unique_PXD004705A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_PD_01 <- dplyr::select(Unique_PXD004939A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_PD_01 <- dplyr::select(Unique_PXD005241A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_PD_01 <- dplyr::select(Unique_PXD012764A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_PD_01 <- dplyr::select(Unique_PXD019291A_pform_PD_01,c(PROTEIN_LOC,pipeline,Type))

Unique_PXD000923A_pform_MQ_01 <- cbind.data.frame(distinct(PXD000923A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002222A_pform_MQ_01 <- cbind.data.frame(distinct(PXD002222A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD002756A_pform_MQ_01 <- cbind.data.frame(distinct(PXD002756A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004705A_pform_MQ_01 <- cbind.data.frame(distinct(PXD004705A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD004939A_pform_MQ_01 <- cbind.data.frame(distinct(PXD004939A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD005241A_pform_MQ_01 <- cbind.data.frame(distinct(PXD005241A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD012764A_pform_MQ_01 <- cbind.data.frame(distinct(PXD012764A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")
Unique_PXD019291A_pform_MQ_01 <- cbind.data.frame(distinct(PXD019291A_pform_MQ_01,PROTEIN_LOC, .keep_all = TRUE),pipeline="MQ")

Unique_PXD000923A_pform_MQ_01 <- dplyr::select(Unique_PXD000923A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002222A_pform_MQ_01 <- dplyr::select(Unique_PXD002222A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD002756A_pform_MQ_01 <- dplyr::select(Unique_PXD002756A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004705A_pform_MQ_01 <- dplyr::select(Unique_PXD004705A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD004939A_pform_MQ_01 <- dplyr::select(Unique_PXD004939A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD005241A_pform_MQ_01 <- dplyr::select(Unique_PXD005241A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD012764A_pform_MQ_01 <- dplyr::select(Unique_PXD012764A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))
Unique_PXD019291A_pform_MQ_01 <- dplyr::select(Unique_PXD019291A_pform_MQ_01,c(PROTEIN_LOC,pipeline,Type))

# Merging data #
################

M1_PXD000923A_01 <- merge(Unique_PXD000923A_pform_TPP_01,Unique_PXD000923A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD000923A_01 <- merge(M1_PXD000923A_01,Unique_PXD000923A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD002222A_01 <- merge(Unique_PXD002222A_pform_TPP_01,Unique_PXD002222A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002222A_01 <- merge(M1_PXD002222A_01,Unique_PXD002222A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD002756A_01 <- merge(Unique_PXD002756A_pform_TPP_01,Unique_PXD002756A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD002756A_01 <- merge(M1_PXD002756A_01,Unique_PXD002756A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD004705A_01 <- merge(Unique_PXD004705A_pform_TPP_01,Unique_PXD004705A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004705A_01 <- merge(M1_PXD004705A_01,Unique_PXD004705A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD004939A_01 <- merge(Unique_PXD004939A_pform_TPP_01,Unique_PXD004939A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD004939A_01 <- merge(M1_PXD004939A_01,Unique_PXD004939A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD005241A_01 <- merge(Unique_PXD005241A_pform_TPP_01,Unique_PXD005241A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD005241A_01 <- merge(M1_PXD005241A_01,Unique_PXD005241A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD012764A_01 <- merge(Unique_PXD012764A_pform_TPP_01,Unique_PXD012764A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD012764A_01 <- merge(M1_PXD012764A_01,Unique_PXD012764A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)
M1_PXD019291A_01 <- merge(Unique_PXD019291A_pform_TPP_01,Unique_PXD019291A_pform_PD_01, by="PROTEIN_LOC", all = TRUE)
Merged_PXD019291A_01 <- merge(M1_PXD019291A_01,Unique_PXD019291A_pform_MQ_01, by="PROTEIN_LOC", all = TRUE)

Merged_PXD000923A_01$Group <- paste0(Merged_PXD000923A_01$pipeline.x,"_",Merged_PXD000923A_01$pipeline.y,"_",Merged_PXD000923A_01$pipeline)
Merged_PXD000923A_01$Group <- gsub('_NA', '', Merged_PXD000923A_01$Group)
Merged_PXD000923A_01$Group <- gsub('NA_', '', Merged_PXD000923A_01$Group)
Merged_PXD000923A_01$Type <- coalesce(Merged_PXD000923A_01$Type,Merged_PXD000923A_01$Type.x,Merged_PXD000923A_01$Type.y)

Merged_PXD002222A_01$Group <- paste0(Merged_PXD002222A_01$pipeline.x,"_",Merged_PXD002222A_01$pipeline.y,"_",Merged_PXD002222A_01$pipeline)
Merged_PXD002222A_01$Group <- gsub('_NA', '', Merged_PXD002222A_01$Group)
Merged_PXD002222A_01$Group <- gsub('NA_', '', Merged_PXD002222A_01$Group)
Merged_PXD002222A_01$Type <- coalesce(Merged_PXD002222A_01$Type,Merged_PXD002222A_01$Type.x,Merged_PXD002222A_01$Type.y)

Merged_PXD002756A_01$Group <- paste0(Merged_PXD002756A_01$pipeline.x,"_",Merged_PXD002756A_01$pipeline.y,"_",Merged_PXD002756A_01$pipeline)
Merged_PXD002756A_01$Group <- gsub('_NA', '', Merged_PXD002756A_01$Group)
Merged_PXD002756A_01$Group <- gsub('NA_', '', Merged_PXD002756A_01$Group)
Merged_PXD002756A_01$Type <- coalesce(Merged_PXD002756A_01$Type,Merged_PXD002756A_01$Type.x,Merged_PXD002756A_01$Type.y)

Merged_PXD004705A_01$Group <- paste0(Merged_PXD004705A_01$pipeline.x,"_",Merged_PXD004705A_01$pipeline.y,"_",Merged_PXD004705A_01$pipeline)
Merged_PXD004705A_01$Group <- gsub('_NA', '', Merged_PXD004705A_01$Group)
Merged_PXD004705A_01$Group <- gsub('NA_', '', Merged_PXD004705A_01$Group)
Merged_PXD004705A_01$Type <- coalesce(Merged_PXD004705A_01$Type,Merged_PXD004705A_01$Type.x,Merged_PXD004705A_01$Type.y)

Merged_PXD004939A_01$Group <- paste0(Merged_PXD004939A_01$pipeline.x,"_",Merged_PXD004939A_01$pipeline.y,"_",Merged_PXD004939A_01$pipeline)
Merged_PXD004939A_01$Group <- gsub('_NA', '', Merged_PXD004939A_01$Group)
Merged_PXD004939A_01$Group <- gsub('NA_', '', Merged_PXD004939A_01$Group)
Merged_PXD004939A_01$Type <- coalesce(Merged_PXD004939A_01$Type,Merged_PXD004939A_01$Type.x,Merged_PXD004939A_01$Type.y)

Merged_PXD005241A_01$Group <- paste0(Merged_PXD005241A_01$pipeline.x,"_",Merged_PXD005241A_01$pipeline.y,"_",Merged_PXD005241A_01$pipeline)
Merged_PXD005241A_01$Group <- gsub('_NA', '', Merged_PXD005241A_01$Group)
Merged_PXD005241A_01$Group <- gsub('NA_', '', Merged_PXD005241A_01$Group)
Merged_PXD005241A_01$Type <- coalesce(Merged_PXD005241A_01$Type,Merged_PXD005241A_01$Type.x,Merged_PXD005241A_01$Type.y)

Merged_PXD012764A_01$Group <- paste0(Merged_PXD012764A_01$pipeline.x,"_",Merged_PXD012764A_01$pipeline.y,"_",Merged_PXD012764A_01$pipeline)
Merged_PXD012764A_01$Group <- gsub('_NA', '', Merged_PXD012764A_01$Group)
Merged_PXD012764A_01$Group <- gsub('NA_', '', Merged_PXD012764A_01$Group)
Merged_PXD012764A_01$Type <- coalesce(Merged_PXD012764A_01$Type,Merged_PXD012764A_01$Type.x,Merged_PXD012764A_01$Type.y)

Merged_PXD019291A_01$Group <- paste0(Merged_PXD019291A_01$pipeline.x,"_",Merged_PXD019291A_01$pipeline.y,"_",Merged_PXD019291A_01$pipeline)
Merged_PXD019291A_01$Group <- gsub('_NA', '', Merged_PXD019291A_01$Group)
Merged_PXD019291A_01$Group <- gsub('NA_', '', Merged_PXD019291A_01$Group)
Merged_PXD019291A_01$Type <- coalesce(Merged_PXD019291A_01$Type,Merged_PXD019291A_01$Type.x,Merged_PXD019291A_01$Type.y)

CrossTable(Merged_PXD000923A_01$Group,Merged_PXD000923A_01$Type)
CrossTable(Merged_PXD002222A_01$Group,Merged_PXD002222A_01$Type)
CrossTable(Merged_PXD002756A_01$Group,Merged_PXD002756A_01$Type)
CrossTable(Merged_PXD004705A_01$Group,Merged_PXD004705A_01$Type)
CrossTable(Merged_PXD004939A_01$Group,Merged_PXD004939A_01$Type)
CrossTable(Merged_PXD005241A_01$Group,Merged_PXD005241A_01$Type)
CrossTable(Merged_PXD012764A_01$Group,Merged_PXD012764A_01$Type)
CrossTable(Merged_PXD019291A_01$Group,Merged_PXD019291A_01$Type)


